/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blocks.crops;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class DoubleCropBlock
extends CropBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)};
    private final Supplier<Item> seedItemSupplier;

    public DoubleCropBlock(BlockBehaviour.Properties properties, Supplier<Item> seedItemSupplier) {
        super(properties);
        this.seedItemSupplier = seedItemSupplier;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.m_7959_())];
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60734_() instanceof FarmBlock;
    }

    public IntegerProperty m_7959_() {
        return AGE;
    }

    public int m_7419_() {
        return 3;
    }

    public DoubleBlockHalf getHalf(BlockState state) {
        return (DoubleBlockHalf)state.m_61143_(HALF);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float f;
        int age;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9 && (age = this.m_52305_(state)) < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (f = DoubleCropBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
            if (age == this.m_7419_() - 1 && level.m_8055_(pos).m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                if (level.m_8055_(pos.m_7494_()) == Blocks.f_50016_.m_49966_() && level.m_8055_(pos.m_7495_()).m_60734_() instanceof FarmBlock) {
                    level.m_7731_(pos, (BlockState)this.m_52289_(this.m_7419_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
                    level.m_7731_(pos.m_7494_(), (BlockState)this.m_52289_(0).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                }
            } else {
                level.m_7731_(pos, (BlockState)this.m_52289_(age + 1).m_61124_(HALF, (Comparable)((DoubleBlockHalf)level.m_8055_(pos).m_61143_(HALF))), 2);
            }
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected int m_7125_(Level level) {
        return Mth.m_216271_((RandomSource)level.f_46441_, (int)1, (int)2);
    }

    protected ItemLike m_6404_() {
        return (ItemLike)this.seedItemSupplier.get();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return (level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos)) && this.placementChecker(level, pos);
    }

    private boolean placementChecker(LevelReader level, BlockPos pos) {
        BlockState testState = level.m_8055_(pos.m_7495_());
        if (testState.m_60734_() instanceof FarmBlock) {
            return true;
        }
        return testState == this.m_52289_(this.m_7419_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER) && level.m_8055_(pos.m_6625_(2)).m_60734_() instanceof FarmBlock;
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return (!this.m_52307_(state) || level.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_50016_) && level.m_8055_(pos.m_7495_()).m_60734_() instanceof FarmBlock || !this.m_52307_(state) && level.m_8055_(pos.m_7495_()).m_60734_() instanceof DoubleCropBlock;
    }

    public void m_52263_(Level level, BlockPos pos, BlockState state) {
        int maxAge;
        int newAge = this.m_52305_(state) + this.m_7125_(level);
        if (newAge >= (maxAge = this.m_7419_()) && level.m_8055_(pos.m_7494_()) == Blocks.f_50016_.m_49966_() && level.m_8055_(pos.m_7495_()).m_60734_() instanceof FarmBlock) {
            int remainingAge = newAge - maxAge;
            level.m_7731_(pos, this.m_52289_(this.m_7419_()), 2);
            level.m_7731_(pos.m_7494_(), (BlockState)this.m_52289_(remainingAge).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
            return;
        }
        if (newAge > maxAge) {
            newAge = maxAge;
        }
        level.m_7731_(pos, (BlockState)this.m_52289_(newAge).m_61124_(HALF, (Comparable)((DoubleBlockHalf)level.m_8055_(pos).m_61143_(HALF))), 2);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            DoubleCropBlock crop;
            Block below = level.m_8055_(pos.m_7495_()).m_60734_();
            if (state.m_60734_() == this && below == this && (crop = (DoubleCropBlock)level.m_8055_(pos).m_60734_()).m_52305_(state) == this.m_7419_() && crop.getHalf(state) == DoubleBlockHalf.UPPER) {
                level.m_7731_(pos.m_7495_(), crop.m_49966_(), 2);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, HALF});
    }
}

